/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.capability.object;

import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.api.common.data.IPlayerCapEntry;
import dev.toma.gunsrpg.api.common.data.IQuests;
import dev.toma.gunsrpg.api.common.data.ITraderStandings;
import dev.toma.gunsrpg.common.capability.object.PlayerTraderStandings;
import dev.toma.gunsrpg.common.quests.QuestSystem;
import dev.toma.gunsrpg.common.quests.quest.Quest;
import dev.toma.gunsrpg.common.quests.quest.QuestTypes;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public class PlayerQuests
implements IQuests,
IPlayerCapEntry {
    private final PlayerEntity player;
    private final PlayerTraderStandings standings;
    private Quest<?> activeQuest;
    private IPlayerCapEntry.IClientSynchReq syncRequestFactory;

    public PlayerQuests(PlayerEntity player) {
        this.player = player;
        this.standings = new PlayerTraderStandings(() -> this.syncRequestFactory, player);
    }

    @Override
    public ITraderStandings getTraderStandings() {
        return this.standings;
    }

    @Override
    public Optional<Quest<?>> getActiveQuest() {
        return Optional.ofNullable(this.activeQuest);
    }

    @Override
    public void assignQuest(Quest<?> quest) {
        this.setActiveQuest(quest);
    }

    @Override
    public void clearActiveQuest() {
        this.setActiveQuest(null);
    }

    private void setActiveQuest(Quest<?> quest) {
        this.activeQuest = quest;
        this.syncRequestFactory.makeSyncRequest();
        GunsRPG.log.debug(QuestSystem.MARKER, "Active quest changed for {} to {}", (Object)this.player.func_200200_C_().getString(), quest);
    }

    @Override
    public int getFlag() {
        return 4;
    }

    @Override
    public void toNbt(CompoundNBT nbt) {
        nbt.func_218657_a("standings", (INBT)this.standings.serializeNBT());
        if (this.activeQuest != null) {
            nbt.func_218657_a("quest", (INBT)this.activeQuest.serialize());
        }
    }

    @Override
    public void fromNbt(CompoundNBT nbt) {
        this.standings.deserializeNBT(nbt.func_150295_c("standings", 10));
        this.activeQuest = nbt.func_74764_b("quest") ? QuestTypes.getFromNbt(nbt.func_74775_l("quest")) : null;
        this.getActiveQuest().ifPresent(quest -> quest.assign(this.player));
    }

    @Override
    public void setClientSynch(IPlayerCapEntry.IClientSynchReq request) {
        this.syncRequestFactory = request;
    }
}

